﻿/**
 * Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

// Tool scripts for the sample pages.
// This file can be ignored and is not required to make use of CKEditor.

(function () {
    // Check for sample compliance.
    CKEDITOR.on('instanceReady', function (ev) {
        var editor = ev.editor,
            meta = CKEDITOR.document.$.getElementsByName('ckeditor-sample-required-plugins'),
            requires = meta.length ? CKEDITOR.dom.element.get(meta[0]).getAttribute('content').split(',') : [],
            missing = [];

        if (requires.length) {
            for (var i = 0; i < requires.length; i++) {
                if (!editor.plugins[requires[i]])
                    missing.push('<code>' + requires[i] + '</code>');
            }

            if (missing.length) {
                var warn = CKEDITOR.dom.element.createFromHtml(
                    '<div class="warning">' +
                    '<span>To fully experience this demo, the ' + missing.join(', ') + ' plugin' + ( missing.length > 1 ? 's are' : ' is' ) + ' required.</span>' +
                    '</div>'
                );
                warn.insertBefore(editor.container);
            }
        }
    });
})();
