<?php require_once("includes/initialize.php");
if (!$session->is_logged_in()) {
    redirect_to("index.php");
}
$user_data = Userdata::find_by_id($session->user_id);
$biodata = Biodata::find_by_id($user_data->formno, $user_data->email);
$transact_feedback = Transaction::authenticate($biodata->formno, $biodata->email);
$id = $session->user_id;
$user_data = Userdata::find_by_id($session->user_id);
$mode = $user_data->mode;
$user_data->std_process_id;

//$pay_settings = Pay_settings::authenticate(1);
if ($user_data->std_process_id < 3) {
    $level = $user_data->std_process_id + 1;
    $update_process = Userdata::update($id, $level);
}

//A4 width: 219mm
//default margin : 10mm each side
//writable horizontal : 219 - (10*2)=189mm

$pdf = new FPDF('p', 'mm', 'A4');

$pdf->AddPage();

//set font to arial, bold, 14pt
$pdf->SetFont('Arial', 'B', 16);

//cell(width , height , text , border , end line , [align] )
$pdf->Cell(189, 5, 'OSUN STATE COLLEGE OF TECHNOLOGY, ESA OKE.', 0, 1, 'C');
$pdf->Cell(189, 5, '', 0, 1);
$pdf->SetFont('Arial', 'B', 14);

$pdf->Cell(189, 5, 'Acceptance Payment Receipt', 0, 1, 'C');
//$pdf->Cell(59 ,5,'Receipt',0,1);//end of line

//set font to arial, regular, 12pt
$pdf->Cell(189, 5, '', 0, 1);

$pdf->SetFont('Arial', '', 12);

$pdf->Cell(30, 5, 'Form no: ', 0, 0);
$pdf->Cell(40, 5, strtoupper($biodata->formno), 0, 0);

$pdf->Cell(50, 5, '', 0, 0);//end of line

//$pdf->Cell(80 ,5,'',0,0);
$pdf->Cell(20, 5, 'Date: ', 0);
$pdf->Cell(49, 5, date('d/m/Y h:i a'), 0, 1);//end of line


$pdf->Cell(30, 5, 'Department: ', 0, 0);
$pdf->Cell(40, 5, strtoupper($biodata->courses), 0, 0);

$pdf->Cell(50, 5, '', 0, 0);//end of line


//$pdf->Cell(120, 5,'',0,0);
$pdf->Cell(20, 5, 'Level: ', 0);
$pdf->Cell(49, 5, strtoupper($transact_feedback->programme), 0, 1);//end of line

$pdf->Cell(30, 5, 'Phone: ', 0, 0);
$pdf->Cell(90, 5, $biodata->phone, 0, 0);
$pdf->Cell(30, 5, 'Transaction ID: ', 0);
$pdf->Cell(44, 5, strtoupper($transact_feedback->txt_ref), 0, 1);//end


//make a dummy empty cell as a vertical spacer
$pdf->Cell(189, 5, '', 0, 1);//end of line

//billing address

//add dummy cell at beginning of each line for identification
//$pdf->Cell(10 ,5,'',0,0);
$pdf->Cell(189, 5, 'FULLNAME: ' . strtoupper($biodata->surname . ' ' . $biodata->othernames), 0, 1, 'C');
$pdf->Cell(189, 3, '', 0, 1);

/*$pdf->Cell(10 ,5,'',0,0);
$pdf->Cell(90 ,5,'[Address]',0,1);

$pdf->Cell(10 ,5,'',0,0);
$pdf->Cell(90 ,5,'[Phone]',0,1);*/

//make a dummy empty cell as a vertical spacer
//$pdf->Cell(189, 10,'',0,1);//end of line

//Invoice contents
$pdf->SetFont('Arial', 'B', 12);

$pdf->Cell(130, 5, 'Description', 1, 0);
$pdf->Cell(25, 5, '', 1, 0);
$pdf->Cell(34, 5, 'Amount', 1, 1);//end of line

$pdf->SetFont('Arial', '', 12);

//Numbers are right-aligned so we give 'R' after new line parameter
$pdf->Cell(130, 5, 'Acceptance fees', 1, 0);
$pdf->Cell(25, 5, '', 1, 0);
$pdf->Cell(34, 5, $pay_settings->amount, 1, 1, 'R');//end of line

$pdf->Cell(130, 5, 'Additional charges', 1, 0);
$pdf->Cell(25, 5, '', 1, 0);
$pdf->Cell(34, 5, $pay_settings->charge_interswitch + $pay_settings->charge_omoluabi, 1, 1, 'R');//end of line

//$pdf->Cell(130 ,5,'Something else',1,0);
//$pdf->Cell(25  ,5,'_',1,0);
//$pdf->Cell(34 ,5,'1,000',1,1,'R');//end of line


//summary
/*$pdf->Cell(130 ,5,'',0,0);
$pdf->Cell(25  ,5,'subtotal',1,0);
$pdf->Cell(4 ,5,'$',1,0);
$pdf->Cell(30 ,5,'4,450',1,1,'R');//end of line

$pdf->Cell(130 ,5,'',0,0);
$pdf->Cell(25  ,5,'Taxable', 1, 0);
$pdf->Cell(4 ,5,'$',1,0);
$pdf->Cell(30 ,5,'0',1,1,'R');//end of line

$pdf->Cell(130 ,5,'',0,0);
$pdf->Cell(25  ,5,'Tax Rate',1, 0);
$pdf->Cell(4 ,5,'$',1,0);
$pdf->Cell(30 ,5,'10%',1,1,'R');*///end of line

$pdf->Cell(130, 5, '', 0, 0);
$pdf->Cell(25, 5, 'Total Due', 1, 0);
$pdf->Cell(4, 5, 'N', 1, 0);
$pdf->Cell(30, 5, $pay_settings->amount + $pay_settings->charge_interswitch + $pay_settings->charge_omoluabi, 1, 1, 'R');//end of line

//clear unnecessary borders

/*$pdf->Cell(130 ,5,'',0,1);
$pdf->Cell(130 ,5,'',0,1);
$pdf->Cell(130 ,5,'',0,1);

$pdf->Cell(50 ,5,'',0,0);
$pdf->Cell(90 ,5,'<a href=\"logout.php\">LOGOUT</a>',0,0);
$pdf->Cell(49 ,5,'<a href=\"dashboard.php\">LOGOUT</a>',0,1);
*/


$pdf->Output();
?>